﻿using System;
using System.Web.UI.WebControls;
using System.ComponentModel;

namespace VIRP_WEB.Controls.Custom.EFR
{
    public partial class FromToDate : System.Web.UI.UserControl
    {
        public string DateValue
        {
            get
            {
                return TextBoxDate.Text;
            }
            set
            {
                TextBoxDate.Text = value;
            }
        }
        [Browsable(true)]
        [Description("CustomValidatorTextBoxDate ValidationGroup")]
        [DefaultValue("Save")]
        public string CustomValidatorValidationGroup
        {
            get
            {
                return this.RangeValidatorTxtDate.ValidationGroup;
            }
            set
            {
                if (!string.IsNullOrEmpty(value))
                {
                    CustomValidatorTextBoxDate.ValidationGroup = value;
                }
                else if (!string.IsNullOrEmpty(RangeValidatorTxtDate.ValidationGroup))
                {
                    CustomValidatorTextBoxDate.ValidationGroup =
                        RangeValidatorTxtDate.ValidationGroup;
                }
            }
        }
        [Description("Enable CustomValidatorTextBoxDate")]
        [DefaultValue(false)]
        public bool EnableToDateCompare
        {
            get
            {
                return CustomValidatorTextBoxDate.Enabled;
            }
            set
            {
                CustomValidatorTextBoxDate.Enabled = value;
            }
        }
        private string toDateCompareErrorMessage;
        [Browsable(true)]
        [Description("RangeValidatorTxtDate ToDateCompare ErrorMessage")]
        [DefaultValue("")]
        public string ToDateCompareErrorMessage
        {
            get
            {
                return toDateCompareErrorMessage;
            }
            set
            {
                toDateCompareErrorMessage = value;
                CustomValidatorTextBoxDate.ErrorMessage = toDateCompareErrorMessage;
            }
        }
        private string toDateCompareDate;
        [Browsable(true)]
        [Description("ToDateCompare Date")]
        [DefaultValue("01/01/3000")]
        public string ToDateCompareDate
        {
            get
            {
                return toDateCompareDate;
            }
            set
            {
                toDateCompareDate = value;
            }
        }
        [Browsable(true)]
        [Description("RangeValidatorTxtDate ToDateCompare")]
        [DefaultValue(false)]
        public bool ToDateCompare
        {
            get
            {
                return toDate;
            }
            set
            {
                toDate = value;
                RangeValidatorTxtDate.MaximumValue = DateTime.Now.ToShortDateString();
            }
        }
        [Browsable(true)]
        [Description("RangeValidatorTxtDate Date Time From")]
        [DefaultValue("01/01/1900")]
        public string DateTimeFrom
        {
            get
            {
                return RangeValidatorTxtDate.MinimumValue;
            }
            set
            {
                RangeValidatorTxtDate.MinimumValue = value;
            }
        }
        private bool toDate = false;
        [Browsable(true)]
        [Description("RangeValidatorTxtDate ToDate")]
        [DefaultValue(false)]
        public bool ToDate
        {
            get
            {
                return toDate;
            }
            set
            {
                toDate = value;
                RangeValidatorTxtDate.MaximumValue = DateTime.Now.ToShortDateString();
            }
        }
        [Browsable(true)]
        [Description("RangeValidatorTxtDate ErrorMessage")]
        [DefaultValue("Invalid Date")]
        public string ErrorMessage
        {
            get
            {
                return RangeValidatorTxtDate.ErrorMessage;
            }
            set
            {
                RangeValidatorTxtDate.ErrorMessage = value;
            }
        }
        [Browsable(true)]
        [Description("RangeValidatorTxtDate ValidationGroup")]
        [DefaultValue("Save")]
        public string ValidationGroup
        {
            get
            {
                return this.RangeValidatorTxtDate.ValidationGroup;
            }
            set
            {
                if (!string.IsNullOrEmpty(value))
                {
                    RangeValidatorTxtDate.ValidationGroup = value;
                }
                else if (!string.IsNullOrEmpty(RequiredFieldValidatorTxtDate.ValidationGroup))
                {
                    RangeValidatorTxtDate.ValidationGroup =
                        RequiredFieldValidatorTxtDate.ValidationGroup;
                }
            }
        }
        [Browsable(true)]
        [Description("RangeValidatorTxtDate StartTabIndex")]
        [DefaultValue("Save")]
        public short StartTabIndex
        {
            get
            {
                return TextBoxDate.TabIndex;
            }
            set
            {
                TextBoxDate.TabIndex = value;
                RangeValidatorTxtDate.TabIndex = (short)(value + 1);
                RequiredFieldValidatorTxtDate.TabIndex = (short)(value + 2);
            }
        }
        [Browsable(true)]
        [Description("Text Box Date")]
        public TextBox Date
        {
            get
            {
                return TextBoxDate;
            }
            set
            {
                TextBoxDate = value;
            }
        }
        [Browsable(true)]
        [Description("Enable RequiredFieldValidatorTxtDate")]
        [DefaultValue(false)]
        public bool Required
        {
            get
            {
                return RequiredFieldValidatorTxtDate.Enabled;
            }
            set
            {
                RequiredFieldValidatorTxtDate.Enabled = value;
            }
        }
        [Browsable(true)]
        [Description("RequiredFieldValidatorTxtDate ValidationGroup")]
        [DefaultValue("")]
        public string RequiredValidatorValidationGroup
        {
            get
            {
                return RequiredFieldValidatorTxtDate.ValidationGroup;
            }
            set
            {
                if (!string.IsNullOrEmpty(value))
                {
                    RequiredFieldValidatorTxtDate.ValidationGroup = value;

                    if (string.IsNullOrEmpty(RangeValidatorTxtDate.ValidationGroup))
                    {
                        RangeValidatorTxtDate.ValidationGroup =
                            RequiredFieldValidatorTxtDate.ValidationGroup;
                    }
                }
                else if (!string.IsNullOrEmpty(RangeValidatorTxtDate.ValidationGroup))
                {
                    RequiredFieldValidatorTxtDate.ValidationGroup =
                        RangeValidatorTxtDate.ValidationGroup;
                }
            }
        }
        [Browsable(true)]
        [Description("RequiredFieldValidatorTxtDate Error Message")]
        [DefaultValue("Date is required")]
        public string RequiredFieldValidatorErrorMessage
        {
            get
            {
                return RequiredFieldValidatorTxtDate.ErrorMessage;
            }
            set
            {
                RequiredFieldValidatorTxtDate.ErrorMessage = value;
            }
        }
        public DateTime DateTimeTo
        {
            get
            {
                return DateTime.Now;
            }
        }

        protected void Page_PreRender(object sender, EventArgs e)
        {
            RangeValidatorTxtDate.MaximumValue = DateTime.Today.AddYears(100).ToShortDateString();
        }

        protected void CustomValidatorTextBoxDate_ServerValidate(object source, ServerValidateEventArgs args)
        {
            if (DateTime.Parse(DateValue) < DateTime.Parse(ToDateCompareDate))
            {
                args.IsValid = false;
            }
        }
    }
}
